import { createSlice, createAsyncThunk } from "@reduxjs/toolkit";
import { filterProductData } from "../../../screens/Home/FeatureDIsplay/filterProductData.js";
import { queryResponse } from "../util/processResponse.js";

const initialState = {
    vendorProducts: [],
    loading: true,
    nextPageUrl: "",
    loadMore: false,
    shopAlias: {}
};

export const getVendorProducts = createAsyncThunk(
    "items/getVendorProducts",
    async (URL) => {
        const response = await queryResponse(URL, "GET");
        return response;
    }
);
export const getMoreVendorProducts = createAsyncThunk(
    "items/getMoreVendorProducts",
    async (URL) => {
        const response = await queryResponse(URL, "GET");
        return response;
    }
);

const vendorProductsSlice = createSlice({
    name: "items",
    initialState,
    reducers: {
        resetVendorProducts: (state, { payload }) => {
            state.vendorProducts = [];
            state.loadMore = false;
            state.loading = true;
            state.nextPageUrl = "";
        },
    },
    extraReducers: (builder) => {
        builder.addCase(getVendorProducts.pending, (state) => {
            state.loading = true;
        });
        builder.addCase(getVendorProducts.fulfilled, (state, { payload }) => {
            const { 
                data = [], 
                pagination: { next_page_url } = {}, 
                otherData 
            } = payload?.records || {};
            const { code } = payload?.status || {};
            if (code == 200) {
                let newData = filterProductData(data);
                state.vendorProducts = newData;
                state.nextPageUrl = next_page_url;
                state.shopAlias = otherData?.shop?.alias
            } else {
                state.vendorProducts = state.vendorProducts;
            }
            state.loading = false;
        });
        builder.addCase(getVendorProducts.rejected, (state) => {
            state.loading = false;
        });
        builder.addCase(getMoreVendorProducts.pending, (state) => {
            state.loadMore = true;
        });
        builder.addCase(
            getMoreVendorProducts.fulfilled,
            (state, { payload }) => {
                const { data = [], pagination: { next_page_url } = {} } =
                    payload?.records || {};
                const { code } = payload?.status || {};
                if (code == 200) {
                    let newData = filterProductData(data);
                    state.vendorProducts = [
                        ...state.vendorProducts,
                        ...newData,
                    ];
                    state.nextPageUrl = next_page_url;
                } else {
                    state.vendorProducts = state.vendorProducts;
                }
                state.loadMore = false;
            }
        );
        builder.addCase(getMoreVendorProducts.rejected, (state) => {
            state.loadMore = false;
        });
    },
});

export const { resetVendorProducts } = vendorProductsSlice.actions;
export default vendorProductsSlice.reducer;